
#include "Streaming_Buffer.h"


StreamBuffer::StreamBuffer(const unsigned int blocksize, STREAM_MODE mode)
{
	this->m_bFileDone = true;
	this->m_bFileOpen = false;
	this->m_iBlocksize = blocksize;
	this->m_pcFilename = NULL;
	this->m_pFileHandle = NULL;
	this->m_pcFilepath = NULL;
	this->m_pucBuffer = NULL;
	this->m_uiFilesizeLeft = 0;
	this->m_uiOriginalFilesize = 0;
	this->m_uiCurrentPos = 0;
	this->m_uiLastDataRead = 0;
	this->m_iLastError = STREAM_FILE_END;
	this->m_Filemode = mode;
}



StreamBuffer::~StreamBuffer()
{
	if(NULL != this->m_pcFilename)
	{
		delete[](this->m_pcFilename);
		this->m_pcFilename = NULL;
	}

	if(NULL != this->m_pcFilepath)
	{
		delete[](this->m_pcFilepath);
		this->m_pcFilepath = NULL;
	}

	if(NULL != this->m_pFileHandle)
	{
		fclose(this->m_pFileHandle);
		this->m_pFileHandle = NULL;
	}

	if(NULL != this->m_pucBuffer)
	{
		delete[](this->m_pucBuffer);
		this->m_pucBuffer = NULL;
	}

	this->m_bFileDone = true;
	this->m_bFileOpen = false;
	this->m_uiFilesizeLeft = 0;
	this->m_uiOriginalFilesize = 0;
	this->m_uiCurrentPos = 0;
	this->m_uiLastDataRead = 0;
	this->m_iLastError = STREAM_FILE_END;

}



/*
	ffnen einer Datei, sowie Erzeugen des Buffers
	anhand der Blockgre.
	Es werden ausserdem die ersten Daten in den
	Buffer gelesen.

*/
int StreamBuffer::StreamOpen(const char *filename, const char *path)
{
	if(NULL == filename)
	{
		this->m_iLastError = STREAM_INIT_FAILED;
		return STREAM_INIT_FAILED; 
	}

	unsigned int sizePath = 0;
	unsigned int sizeFilename = 0;
	unsigned int size = 0;
	char *fullName = NULL;


	try
	{
		this->m_pcFilename = new char[strlen(filename)+1];
		
		if(NULL != path)
		{
			this->m_pcFilepath = new char[strlen(path)+1];
		}
	}
	catch(exception bad_alloc)
	{
		throw(bad_alloc);
		this->m_iLastError = STREAM_NO_MEM;
		return STREAM_NO_MEM;
	}

	// falls Pfad vorhanden
	if(NULL != path)
	{
		sizePath = strlen(path);
		
		memset(this->m_pcFilepath, 0, sizePath+1);
		strncpy(this->m_pcFilepath, path, sizePath);
		this->m_pcFilepath[sizePath] = '\0';
		
		size += sizePath;
	}

	

	sizeFilename = strlen(filename);

	memset(this->m_pcFilename, 0, strlen(filename)+1);
	strncpy(this->m_pcFilename, filename, strlen(filename));
	this->m_pcFilename[strlen(filename)] = '\0';

	size += sizeFilename;

	size += 1;

	try
	{
		fullName = new char[size];
	}
	catch(exception bad_alloc)
	{
		throw(bad_alloc);
		this->m_iLastError = STREAM_NO_MEM;
		return STREAM_NO_MEM;
	}

	memset(fullName, 0, size);

	if(NULL != path)
	{
		strncat(fullName, path, strlen(path));
	}

	strncat(fullName, filename, strlen(filename));


	// Datei jetzt ffnen....
	switch(this->m_Filemode)
	{
	case MODE_BIN:
		{ 
			this->m_pFileHandle = fopen(fullName, "rb"); 
		}break;

	case MODE_TEXT:	
		{
			this->m_pFileHandle = fopen(fullName, "r");  
		}break;

	default:
		{ 
			this->m_pFileHandle = fopen(fullName, "rb"); 
		};
	}


	if(NULL == this->m_pFileHandle)
	{
		delete[](fullName);
		this->m_iLastError = STREAM_FILE_NOT_FOUND;
		return STREAM_FILE_NOT_FOUND;
	}

	// Dateigre feststellen
	fseek(this->m_pFileHandle, 0, SEEK_END);
	this->m_uiFilesizeLeft = ftell(this->m_pFileHandle);
	fseek(this->m_pFileHandle, 0, SEEK_SET);

	this->m_uiOriginalFilesize = this->m_uiFilesizeLeft;

	// Buffer erstellen
	try
	{
		this->m_pucBuffer = new unsigned char[this->m_iBlocksize];
	}
	catch(exception bad_alloc)
	{
		delete[](fullName);
		fclose(this->m_pFileHandle);
		throw(bad_alloc);
		this->m_iLastError = STREAM_NO_MEM;
		return STREAM_NO_MEM;
	}

	memset(this->m_pucBuffer, 0, this->m_iBlocksize);

	// die ersten Daten lesen...
	int datasize = 0;
	
	datasize = RefreshBuffer();

	delete[](fullName);
	fullName = NULL;


	this->m_iLastError = STREAM_OK;
	return STREAM_OK;
}



/*
	Stream schlieen und damit beenden.

*/
void StreamBuffer::StreamClose()
{
	if(true == this->m_bFileOpen)
	{
		if(NULL != this->m_pcFilename)
		{
			delete[](this->m_pcFilename);
			this->m_pcFilename = NULL;
		}

		if(NULL != this->m_pcFilepath)
		{
			delete[](this->m_pcFilepath);
			this->m_pcFilepath = NULL;
		}

		if(NULL != this->m_pFileHandle)
		{
			fclose(this->m_pFileHandle);
			this->m_pFileHandle = NULL;
		}

		if(NULL != this->m_pucBuffer)
		{
			delete[](this->m_pucBuffer);
			this->m_pucBuffer = NULL;
		}

		this->m_bFileDone = true;
		this->m_bFileOpen = false;
		this->m_uiFilesizeLeft = 0;
		this->m_uiOriginalFilesize = 0;
		this->m_uiCurrentPos = 0;
		this->m_uiLastDataRead = 0;

		this->m_iLastError = STREAM_FILE_END;
	}
}



/*
	Fllt den Buffer mit neuen Daten.

	Rckgabewert entspricht der gelesenen Anzahl an Bytes.

*/
long StreamBuffer::RefreshBuffer()
{
	long dataread = 0;

	if((this->m_uiFilesizeLeft < this->m_iBlocksize) || (this->m_uiOriginalFilesize < this->m_iBlocksize))
	{
		// Datei zu klein, deshalb wird sie komplett geladen.
		dataread = fread(this->m_pucBuffer, sizeof(unsigned char), this->m_uiOriginalFilesize, this->m_pFileHandle);

		this->m_bFileDone = true;
		this->m_bFileOpen = true;
		this->m_uiFilesizeLeft -= dataread;	// noch verbleibende Daten / Bytes
		this->m_uiLastDataRead = dataread;  // Anzahl der gelesenen Bytes
		memset(&this->m_pucBuffer[dataread], 0, (this->m_iBlocksize - dataread)); 
	}
	else if(this->m_uiFilesizeLeft > this->m_iBlocksize)
	{
		// noch gengend Daten vorhanden...
		dataread = fread(this->m_pucBuffer, sizeof(unsigned char), this->m_iBlocksize, this->m_pFileHandle);

		this->m_bFileDone = false;
		this->m_bFileOpen = true;
		this->m_uiFilesizeLeft -= dataread;
		this->m_uiLastDataRead = dataread;
	}

	this->m_uiCurrentPos = 0;

	return dataread;
}



/*
	Daten aus dem Buffer lesen...

*/
unsigned char StreamBuffer::ReadByte()
{
	long dataread = -1;


	if(this->m_uiCurrentPos >= this->m_iBlocksize)
	{
		dataread = this->RefreshBuffer();
	
		if(dataread == 0)
		{
			this->m_uiCurrentPos = 0;
			this->m_bFileDone = true;
			this->m_iLastError = STREAM_FILE_END;

			return NULL; 
		}
	}

	if(this->m_uiCurrentPos < this->m_uiLastDataRead) 
	{
		m_iLastError = STREAM_OK;
		return this->m_pucBuffer[this->m_uiCurrentPos++];
	}

	m_iLastError = STREAM_FILE_END;
	m_bFileDone = true;
	m_uiCurrentPos = 0;
	return NULL;
}



/*
	2 Byte (WORD) aus dem Buffer lesen.

*/
inline unsigned short StreamBuffer::ReadWord()
{
	return (unsigned short)((this->ReadByte()<<8) | this->ReadByte());
}

/*
	4 Byte (DWORD) aus dem Buffer lesen.

*/
inline unsigned int StreamBuffer::ReadDWord()
{
	return (unsigned int)((this->ReadByte()<<24) | (this->ReadByte()<<16) | (this->ReadByte()<<8) |
		   this->ReadByte());
}
