#ifndef _STREAMING_BUFFER_CLASS_HEADER_FILE_H_
#define _STREAMING_BUFFER_CLASS_HEADER_FILE_H_

/*
	Dateibuffer, dessen Daten stckweise geladen werden.

	Streaming ohne Ringbuffer.

*/
#include <stdio.h>
#include <string.h>
#include <exception>

// mgliche Rckgabewerte

enum STREAM_MESSAGES	{ STREAM_OK = 0,
						  STREAM_NOT_READY,
						  STREAM_INIT_FAILED,
						  STREAM_FILE_NOT_FOUND,
						  STREAM_FILE_END,
						  STREAM_NO_MEM,
						  STREAM_ALLREADY_OPEN
						};

// Lesemodus
enum STREAM_MODE { MODE_BIN = 0, MODE_TEXT = 1};


class StreamBuffer
{
public:

	// Blocksize in Byte + Lesemodus
	StreamBuffer(const unsigned int blocksize=64000, STREAM_MODE mode=MODE_BIN);
	virtual ~StreamBuffer();

	int StreamOpen(const char *filename, const char *path=NULL);
	void StreamClose();

	unsigned char	ReadByte();
	unsigned short	ReadWord();
	unsigned int	ReadDWord();

	int GetLastError(){ return m_iLastError; }
	bool EndOfFile(){ return ((true == m_bFileDone) && (m_iLastError == STREAM_FILE_END)); }

private:

	long RefreshBuffer();			// Buffer mit neuen Daten fllen.

	unsigned int	m_iBlocksize;
	bool			m_bFileDone;			// Dateiende erreicht?
	bool			m_bFileOpen;			// Datei geffnet?
	unsigned int	m_uiFilesizeLeft;		// Wieviel noch gelesen werden kann....
	unsigned int	m_uiOriginalFilesize;
	int				m_iLastError;			// letzter bekannter Fehler

	unsigned char	*m_pucBuffer;
	unsigned int	m_uiCurrentPos;			// aktuelle Position innerhalb des Buffers
	unsigned int	m_uiLastDataRead;		// Wieviel Byte beim "Refresh" des Buffers gelesen wurden

	FILE			*m_pFileHandle;
	char			*m_pcFilename;
	char			*m_pcFilepath;
	STREAM_MODE		m_Filemode;				// bin oder ascii
};

#endif